class AdvancedUserRecipe1289709253(BasicNewsRecipe):
    title          = u'Health Zone'
    oldest_article = 30
    max_articles_per_feed = 100
    use_embedded_content  = False
    no_stylesheets = True

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''

    
    remove_tags_before = dict(name='h1')
    remove_attributes = ['style', 'font']
    remove_tags = [dict(name='div', attrs={'class':['articleImage','date','author']}),
                   dict(name='div', attrs={'id':['','',]}),
                   dict(name='img'),]

    feeds          = [(u'News and Features', u'http://www.healthzone.ca/health/rss/310459?categories=3828'), 
                          (u'Columns and Blogs', u'http://www.healthzone.ca/health/rss/310505?categories=3829'), 
                          (u'Diet', u'http://www.healthzone.ca/health/rss/350213?categories=3777'),
                          (u'Fitness', u'http://www.healthzone.ca/health/rss/350214?categories=3789'), 
                          (u'Research', u'http://www.healthzone.ca/health/rss/310510?categories=3831'), 
                          (u'Specials and Features', u'http://www.healthzone.ca/health/rss/310508?categories=3832'), 
                          (u'Mens Health', u'http://www.healthzone.ca/health/rss/310489?categories=3754')]
						  
    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup


    def print_version(self, url):
        return url.replace('article', 'articlePrint')
